/**
* \file: NaviStatusImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: Ajay Kumar Sahoo/ RBEI/ECF3 / ajaykumar.sahoo@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_NAVI_STATUS_IMPL_H
#define AAUTO_NAVI_STATUS_IMPL_H

#include <string>
#include <aauto/MessageRouter.h>
#include <uspi/ConfigHandle.h>
#include <aauto/GalReceiver.h>
#include <aauto/AditNavigationStatus.h>
#include <aauto/NavigationStatusEndpoint.h>

namespace adit { namespace aauto {

class NaviStatusImpl : public INavigationStatusCallbacks
{
public:

    NaviStatusImpl(NavigationStatusEndpoint* inEndpoint,
                                       void* inSessionContext);
    ~NaviStatusImpl();

    void setConfigItem(std::string inKey, std::string inValue);
    void registerCallbacks(IAditNavigationStatusCallbacks* inCallbacks);
    bool init();
    void shutdown();

protected:
    void navigationStatusCallback(int status);
    void navigationNextTurnCallback(const std::string& road, int turnSide, int event,
                                      const std::string& image, int turnAngle, int turnNumber);
    void navigationNextTurnDistanceCallback(int distanceMeters, int timeSeconds, int displayDistanceE3,
                                              NavigationNextTurnDistanceEvent_DistanceUnits displayDistanceUnit);
private:
    void* mSessionContext;
    NavigationStatusEndpoint* mEndpoint;
    IAditNavigationStatusCallbacks* mCallbacks;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_NAVI_STATUS_IMPL_H */
